<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('developers', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->decimal('company_commission_rate', 8, 6)->default(0.06);
            $table->decimal('sales_incentive_rate', 8, 6)->default(0.02);
            $table->decimal('vat_rate', 8, 6)->default(0.14);
            $table->decimal('withholding_rate', 8, 6)->default(0.05);
            $table->string('withholding_name')->default('ضريبة المنبع');
            $table->json('default_split_rules')->nullable();
            $table->timestamps();
        });

        Schema::create('deals', function (Blueprint $table) {
            $table->id();
            $table->foreignId('developer_id')->constrained('developers');
            $table->string('unit_name')->nullable();
            $table->string('unit_type')->nullable();
            $table->string('area')->nullable();
            $table->decimal('unit_price', 16, 2);
            $table->decimal('gross_commission', 16, 2);
            $table->decimal('vat_rate', 8, 6);
            $table->decimal('withholding_rate', 8, 6);
            $table->string('withholding_name');
            $table->decimal('base_amount', 16, 2)->nullable();
            $table->decimal('vat_amount', 16, 2)->nullable();
            $table->decimal('withholding_amount', 16, 2)->nullable();
            $table->decimal('cheque_net_received', 16, 2)->nullable();
            $table->decimal('operating_net_before_payouts', 16, 2)->nullable();

            // Cashback
            $table->boolean('has_cashback')->default(false);
            $table->enum('cashback_type', ['fixed', 'percent'])->nullable();
            $table->decimal('cashback_value', 16, 6)->nullable();
            $table->enum('cashback_timing', ['pre_tax', 'post_tax'])->nullable();

            // Commission splits setup (who will receive what). JSON to keep v1 flexible.
            $table->json('commission_splits')->nullable();

            // Incentives from developer (off-treasury)
            $table->json('off_treasury_incentives')->nullable();

            $table->enum('status', ['draft', 'claimed', 'collected', 'closed'])->default('draft');
            $table->timestamps();
        });

        Schema::create('treasuries', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->enum('type', ['bank', 'cash', 'tax'])->default('bank');
            $table->decimal('balance', 16, 2)->default(0);
            $table->timestamps();
        });

        Schema::create('treasury_transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('treasury_id')->constrained('treasuries');
            $table->enum('direction', ['in', 'out', 'transfer_in', 'transfer_out']);
            $table->decimal('amount', 16, 2);
            $table->string('reference_type')->nullable();
            $table->unsignedBigInteger('reference_id')->nullable();
            $table->string('note')->nullable();
            $table->timestamps();
        });

        Schema::create('approvals', function (Blueprint $table) {
            $table->id();
            $table->string('approvable_type');
            $table->unsignedBigInteger('approvable_id');
            $table->enum('status', ['pending', 'approved', 'rejected', 'cancelled'])->default('pending');
            $table->json('chain');
            $table->json('decisions')->nullable();
            $table->timestamp('submitted_at')->nullable();
            $table->timestamp('finalized_at')->nullable();
            $table->timestamps();
            $table->index(['approvable_type', 'approvable_id']);
        });

        Schema::create('attachments', function (Blueprint $table) {
            $table->id();
            $table->string('attachable_type');
            $table->unsignedBigInteger('attachable_id');
            $table->string('file_path');
            $table->string('file_name');
            $table->string('mime_type')->nullable();
            $table->unsignedBigInteger('uploaded_by')->nullable();
            $table->timestamps();
            $table->index(['attachable_type', 'attachable_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('attachments');
        Schema::dropIfExists('approvals');
        Schema::dropIfExists('treasury_transactions');
        Schema::dropIfExists('treasuries');
        Schema::dropIfExists('deals');
        Schema::dropIfExists('developers');
    }
};
