import i18n from "i18next";
import { initReactI18next } from "react-i18next";

const resources = {
  ar: { translation: { dashboard: "لوحة التحكم", approvals: "الاعتمادات", language: "اللغة", theme: "المظهر" } },
  en: { translation: { dashboard: "Dashboard", approvals: "Approvals", language: "Language", theme: "Theme" } }
} as const;

i18n.use(initReactI18next).init({
  resources,
  lng: "ar",
  fallbackLng: "en",
  interpolation: { escapeValue: false }
});

export default i18n;
